import matplotlib.pyplot as plt
import matplotlib
import numpy as np
import os

font = {
    # 'family' : 'normal',
        # 'weight' : 'bold',
        'size'   : 16
}
matplotlib.rc('font', **font)

cov = [0.02, 0.05, 0.1, 0.2, 0.5, 0.8, 1.0]

total_pmin0 =[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0924398375681856e-08, 4.6026524153280055e-08, 4.776945116018948e-07, 9.823960525124636e-07, 2.463465829796108e-06, 2.312807803740256e-06, 4.6647153346594e-07, 7.532206709168381e-08, 1.8598793842384477e-08, 4.649553886305672e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]

total_pmax0 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.268192840883926e-08, 5.2921240804583234e-08, 5.915615314820255e-07, 1.3225748965851016e-06, 3.534454559832236e-06, 3.4528461180394175e-06, 6.882975253845551e-07, 1.1028582594705707e-07, 2.4875577556490632e-08, 5.16945303906569e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]

total_pmin1=[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.433981515696168e-05, 8.418860377846707e-05, 0.0003582999385938106, 0.0006775884157468309, 0.0010316649629829313, 0.0007202900011550638, 0.00022810680076757172, 4.6481068252747195e-05, 5.3210150303759506e-06, 2.417014200725775e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
total_pmax1=[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.6625935606349367e-05, 9.912408355885175e-05, 0.0004386498485821511, 0.0008962083655957266, 0.001442676576833997, 0.0010519185807985776, 0.0003372603487310663, 6.60877222093764e-05, 7.076732517686242e-06, 2.7600550094156784e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]


total_pmin2= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00011817529196299925, 0.0009072722043222306, 0.0030693539825824238, 0.005730833010670669, 0.007407251919668275, 0.005203985802837526, 0.0019856403188105156, 0.0004355948819481492, 4.2166154381741754e-05, 4.556756257870347e-07, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
total_pmax2= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00013670382130208505, 0.0010719232648340514, 0.003720292832723967, 0.007440673375107491, 0.010119178400095564, 0.007415607069819331, 0.002880245934881524, 0.0006067097692028095, 5.5631752470621e-05, 5.225106041424479e-07, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]


total_pmin3= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00028944752518752294, 0.0025965658503598246, 0.008663677558582815, 0.015768727660765366, 0.01886224715225757, 0.013520228847943317, 0.005680734869943291, 0.0013340707546767314, 0.00012754727920956063, 1.7663961211721666e-06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
total_pmax3= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00033385185618338057, 0.003070669123626423, 0.010431903174113428, 0.02016203183613481, 0.0252584249273058, 0.01890766445646004, 0.008128409264249393, 0.0018391439063007943, 0.0001674973913391441, 2.0281705915515002e-06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]


total_pmin4= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00041986123864082156, 0.004149001997405852, 0.014320344717366016, 0.025621585849087143, 0.029451445679906648, 0.021297485094535638, 0.009361974659933527, 0.0023088889987202205, 0.00022565924464427233, 3.3413820605465184e-06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
total_pmax4= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004828245040219064, 0.004907550723477339, 0.017168442894447265, 0.03237755450638574, 0.038840558507593125, 0.029404278014739497, 0.013280606150376711, 0.003167995824431577, 0.00029569397612074877, 3.838929297328585e-06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]


total_pmin5= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004401797399078045, 0.004457434593292557, 0.015590361440487161, 0.02778971985751302, 0.03168664813589274, 0.022932343291707367, 0.010152542442532417, 0.0025343060360301164, 0.0002498590583133756, 3.7227523051959436e-06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
total_pmax5= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0005057070719030692, 0.005272338258581868, 0.01867027759253421, 0.03500454012892686, 0.041615930915385006, 0.03155915401462914, 0.01437167267822633, 0.0034740397627707064, 0.00032726176263343597, 4.27766866996039e-06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]


total_pmin6= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004444141155563312, 0.004537091507216215, 0.015946315724343175, 0.028392473665422538, 0.032298073096949334, 0.023376692440665415, 0.01036782793171988, 0.002598159746410004, 0.00025694827485475376, 3.832101137798519e-06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
total_pmax6= [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.000510398581616889, 0.0053665143757596, 0.01908944509472577, 0.03572462668468237, 0.04235961694446822, 0.03213619770235657, 0.014666214034463538, 0.0035605477646726558, 0.0003365017391817559, 4.403510034745348e-06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]

pmins=[total_pmin0, total_pmin1, total_pmin2, total_pmin3, total_pmin4, total_pmin5, total_pmin6]
pmaxs=[total_pmax0, total_pmax1, total_pmax2, total_pmax3, total_pmax4, total_pmax5, total_pmax6]

index=16
pmin = [pm[index] for pm in pmins]
pmax = [pm[index] for pm in pmaxs]
print(pmin)
print(pmax)
plt.plot(cov, pmax, label="pmax")
plt.plot(cov, pmin, label="pmin")
plt.legend()
plt.xlabel("Covariance")
plt.ylabel("Probability of collision")
ax=plt.gca()
plt.xlim(0, 1.0)
plt.ylim(0, np.max(pmax))
plt.tight_layout()
ax.set_aspect(1.0 / ((np.max(pmax)-0) / 1.0) , adjustable='box')
# plt.show()

os.makedirs("cache", exist_ok=True)
plt.savefig("cache/fig4.png", bbox_inches='tight', pad_inches=0.1)
plt.close()
